<?php
	include 'app.php';
?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
	
	<title><?=$site['nome'];?></title>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

	<!-- CSS
	================================================== -->
 
	<link rel="stylesheet" href="assets/css/style.css?v=<?=$arquivosVersao['css'];?>">
	<link rel="stylesheet" href="color.php?colorBase=<?=str_replace("#", "", $site['cor_base']);?>" id="colors">
</head>

<body>

<!-- Wrapper -->
<div id="wrapper">
	<?php include '__header.php';?>
	
	<div class="clearfix"></div> 


<!-- Banner
================================================== -->
<div class="parallax" data-background="<?=$site['homeImagem'];?>" data-color="#000" data-color-opacity="0.65" style="background-size: cover">
	<div class="parallax-content">

		<div class="container">
			<div class="row">
				<div class="col-md-12">

					<!-- Main Search Container -->
					<div class="main-search-container">
						<h2><?=$site['homeTitulo'];?></h2>
 						<div class="announce">
							<?=$site['homeDescricao'];?>
						</div>
						<!-- Main Search -->
						<form class="main-search-form" method="GET" action="imoveis">
							
							<!-- Type -->
							<div class="search-type">
								<label class="active"><input class="first-tab" name="busca" value="todos" type="radio">Todos</label>
								<label><input name="busca" type="radio" value="1">Alugar</label>
								<label><input name="busca" type="radio" value="2">Vender</label>
								<div class="search-type-arrow"></div>
							</div>

							
							<!-- Box -->
							<div class="main-search-box">
								
								<!-- Main Search Input -->
								<div class="main-search-input larger-input">
									<select data-placeholder="Selecionar" name="cidade" class="chosen-select-no-single" >
									<option value="">Cidade</option>
									<?php
										$searchItem  = query($conectDB, '', "
											select
												cidade,
												estado
											from
												imovel
											WHERE
												usuario_id = '{$site['usuarioID']}'
											group by
												cidade
											order by
												cidade asc
										"); 
										if( count($searchItem) > 0 ){
											foreach($searchItem as $value)
											{ 
												echo '<option value="'.$value->cidade.'">'.$value->cidade.'/'.$value->estado.'</option>	';
											}
										}
									?>
									</select>
									<button class="button">Buscar</button>
								</div>

								<!-- Row -->
								<div class="row with-forms">

									<!-- Property Type -->
									<div class="col-md-4">
										<select data-placeholder="Selecionar" name="tipo" class="chosen-select-no-single" >
											<option value="">Tipo</option>	
											<?php
												$searchItem  = query($conectDB, '', "
													select
														categoria.id,
														categoria.nome
													from
														imovel,
														categoria
													WHERE
														imovel.usuario_id = '{$site['usuarioID']}' and
														categoria.id = imovel.categoria
													group by
														categoria.id
													order by
														categoria.nome asc
												"); 
												if( count($searchItem) > 0 ){
													foreach($searchItem as $value)
													{ 
														echo '<option value="'.$value->id.'">'.$value->nome.'</option>	';
													}
												}
											?>
										</select>
									</div>
									<div class="col-md-4">
										<div class="select-input">
											<input type="text" name="areaMin" placeholder="Área Mínima" data-unit="m<sup>2</sup>">
										</div>
									</div>
									<div class="col-md-4">
										<div class="select-input">
											<input type="text" name="precoMax" placeholder="Preço Max" data-unit="R$">
										</div>
									</div>
								</div>


								<!-- More Search Options -->
								<a href="#" class="more-search-options-trigger" data-open-title="Mais Opções" data-close-title="Menos Opções"></a>

								<div class="more-search-options">
									<div class="more-search-options-container">


										<div class="row with-forms">

											<!-- Min Area -->
											<div class="col-md-6">
												<select data-placeholder="Quartos" name="quartos" class="chosen-select-no-single" >
													<option label="blank"></option>	
													<option>Quartos</option>	
													<option>1</option>
													<option>2</option>
													<option>3</option>
													<option>4</option>
													<option>5</option>
												</select>
											</div>

											<!-- Max Area -->
											<div class="col-md-6">
												<select data-placeholder="Banheiros"  name="banheiros" class="chosen-select-no-single" >
													<option label="blank"></option>	
													<option>Banheiros</option>	
													<option>1</option>
													<option>2</option>
													<option>3</option>
													<option>4</option>
													<option>5</option>
												</select>
											</div>

										</div>
										<!-- Row / End -->
			
 

									</div>
								</div>
								<!-- More Search Options / End -->


							</div>
							<!-- Box / End -->

						</form>
						<!-- Main Search -->

					</div>
					<!-- Main Search Container / End -->

				</div>
			</div>
		</div>

	</div>
</div>


<!-- Content
================================================== -->
<div class="container">
	<div class="row">
	
		<div class="col-md-12">
			<h3 class="headline margin-bottom-25 margin-top-65">Em Destaque</h3>
		</div>
		
		<!-- Carousel -->
		<div class="col-md-12">
			<div class="carousel">
				<?php
					$searchItem  = query($conectDB, '', "
						select
							imovel.id as imovelID,
							imovel.codigo,
							titulo,
							valor,
							area_total,
							dormitorio,
							banheiro,
							sala,
							situacao,
							bairro,
							if(situacao=1, 'Aluguel', 'Vender') as situacao,
							categoria.id,
							categoria.nome
						from
							imovel,
							categoria
						WHERE
							imovel.usuario_id = '{$site['usuarioID']}' and
							categoria.id = imovel.categoria and
							destaque_home = 1
						
						order by
							imovel.data_criacao desc
					"); 
					if( count($searchItem) > 0 ){
						foreach($searchItem as $data)
						{
							$imagens = '';
							$imagens = array();
							$searchImages  = query($conectDB, '', "
								select
									img
								from
									imovel_galeria
								WHERE
									imovel_id = '{$data->imovelID}'
								
								order by posicao asc
								limit 3
							"); 
 
							if( count($searchImages) >= 1 ){
								foreach($searchImages as $images)
								{
									$imagens[] = $site['imoveisImagens'].'/'.$data->imovelID.'/'.$images->img;
								}
							}
							else
							{
								$imagens[] = $site['imagens']."/storage/sem-foto.jpg";
							}

							include '_imovel_lista_item.php';
						}
					}
				?>

 



			</div>
		</div>
		<!-- Carousel / End -->

	</div>
</div>



  

<?php include '__footer.php';?>



<!-- Scripts
================================================== -->
<script type="text/javascript" src="assets/scripts/jquery-2.2.0.min.js"></script>
<script type="text/javascript" src="assets/scripts/chosen.min.js"></script>
<script type="text/javascript" src="assets/scripts/magnific-popup.min.js"></script>
<script type="text/javascript" src="assets/scripts/owl.carousel.min.js"></script>
<script type="text/javascript" src="assets/scripts/rangeSlider.js"></script>
<script type="text/javascript" src="assets/scripts/sticky-kit.min.js"></script>
<script type="text/javascript" src="assets/scripts/slick.min.js"></script>
<script type="text/javascript" src="assets/scripts/masonry.min.js"></script>
<script type="text/javascript" src="assets/scripts/mmenu.min.js"></script>
<script type="text/javascript" src="assets/scripts/tooltips.min.js"></script>
<script type="text/javascript" src="assets/scripts/custom.js"></script>

<script src="https://kit.fontawesome.com/77e3b86f29.js" crossorigin="anonymous"></script>

</div>
<!-- Wrapper / End -->


</body>
</html>